/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.junglemobs.entity;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.EntityProjectileBase;
import com.lycanitesmobs.junglemobs.JungleMobs;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityPoop
extends EntityProjectileBase {
    public Entity shootingEntity;

    public EntityPoop(World world) {
        super(world);
    }

    public EntityPoop(World world, EntityLivingBase entityLivingBase) {
        super(world, entityLivingBase);
    }

    public EntityPoop(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    @Override
    public void setup() {
        this.entityName = "poop";
        this.group = JungleMobs.group;
        this.setBaseDamage(2);
        this.setProjectileScale(1.0f);
    }

    @Override
    public boolean entityLivingCollision(EntityLivingBase entityLiving) {
        entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76421_d, this.getEffectDuration(3), 0));
        entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76431_k, this.getEffectDuration(5), 0));
        return true;
    }

    @Override
    public boolean canDestroyBlock(BlockPos pos) {
        Block block = this.field_70170_p.func_180495_p(pos).func_177230_c();
        if (ObjectManager.getBlock("PoisonCloud") != null && block == ObjectManager.getBlock("PoisonCloud")) {
            return true;
        }
        if (ObjectManager.getBlock("PoopCloud") != null && block == ObjectManager.getBlock("PoopCloud")) {
            return true;
        }
        if (ObjectManager.getBlock("FrostCloud") != null && block == ObjectManager.getBlock("FrostCloud")) {
            return true;
        }
        return super.canDestroyBlock(pos);
    }

    @Override
    public void placeBlock(World world, BlockPos pos) {
        world.func_175656_a(pos, ObjectManager.getBlock("poopcloud").func_176223_P());
    }

    @Override
    public void onImpactVisuals() {
        for (int i = 0; i < 8; ++i) {
            int[] nArray = new int[1];
            nArray[0] = BlockTallGrass.func_176210_f((IBlockState)Blocks.field_150346_d.func_176223_P());
            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, nArray);
        }
    }

    @Override
    public SoundEvent getLaunchSound() {
        return AssetManager.getSound("poop");
    }
}

